package com.clx.performance.service.impl.breakcontract;

import com.clx.performance.dao.breakcontract.BreakContractSettlementLogDao;
import com.clx.performance.dao.breakcontract.BreakContractSettlementOwnerDetailDao;
import com.clx.performance.model.breakcontract.BreakContractSettlementLog;
import com.clx.performance.service.breakcontract.BreakContractSettlementLogService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementLogServiceImpl implements BreakContractSettlementLogService {

    private final BreakContractSettlementLogDao breakContractSettlementLogDao;

    @Override
    public void saveBreakSettlementLog(String settlementNo, Integer type, String remark, Integer createType, Long createBy, String createName) {
        BreakContractSettlementLog breakContractSettlementLog = new BreakContractSettlementLog();
        breakContractSettlementLog.setCreateBy(createBy);
        breakContractSettlementLog.setCreateName(createName);
        breakContractSettlementLog.setCreateType(createType);
        breakContractSettlementLog.setRemark(remark);
        breakContractSettlementLog.setSettlementNo(settlementNo);
        breakContractSettlementLog.setType(type);
        breakContractSettlementLogDao.saveEntity(breakContractSettlementLog);
    }
}
