package com.clx.performance.model.nbbank;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 宁波银行请求记录
* @Date: 2024/01/20 13:28:28
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class NbBankRecord implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Integer type;                           //类型：1转账直连下单 2银联订单支付收款模式 3交易结果查询 4异步通知交易结果
    private String merId;                           //商户号
    private String merSeqNo;                        //商户号流水号
    private LocalDateTime merDtTm;                  //商户交易时间
    private String transSeqNo;                      //第三方流水号
    private Integer amount;                         //金额 （分）
    private String param;                           //参数
    private String result;                          //方法
    private String errorCode;                       //错误码
    private String errorMsg;                        //错误信息
    private String transStatus;                     //交易状态
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}