package com.clx.performance.mapper.breakcontract;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.breakcontract.BreakContractDriverRecord;
import com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractDriverRecordParam;
import com.clx.performance.sqlProvider.breakcontract.BreakContractDriverRecordSqlProvider;
import com.clx.performance.vo.app.breakcontract.DriverBreakContractDriverRecordVO;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRecordVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
public interface BreakContractDriverRecordMapper extends BaseMapper<BreakContractDriverRecord> {

    /**
     * @see BreakContractDriverRecordSqlProvider#pageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, PageBreakContractDriverRecordParam)
     */
    @SelectProvider(type = BreakContractDriverRecordSqlProvider.class, method = "pageByParam")
    IPage<BreakContractDriverRecordVO> pageByParam(@Param("page") Page<BreakContractDriverRecordVO> page, @Param("param") PageBreakContractDriverRecordParam param);

    /**
     * @see BreakContractDriverRecordSqlProvider#driverPageByParam(com.baomidou.mybatisplus.extension.plugins.pagination.Page, com.clx.performance.param.app.breakcontract.DriverPageBreakContractDriverRecordParam)
     */
    @SelectProvider(type = BreakContractDriverRecordSqlProvider.class, method = "driverPageByParam")
    IPage<DriverBreakContractDriverRecordVO> driverPageByParam(@Param("page") Page<DriverBreakContractDriverRecordVO> page, @Param("param") DriverPageBreakContractDriverRecordParam param);

}
