package com.clx.performance.listener.vehiclewarn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyVehicleWarnConstants;
import com.clx.performance.param.mq.vehiclewarn.VehicleWarnTruckWarnMqParam;
import com.clx.performance.service.vehiclewarn.VehicleWarnMqHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 运单新增 mq
 * @Date: 2023-10-20 16:34:40
 * @Version: 1.0
 */
@Slf4j
@Component
public class VehicleWarnTruckWarnListener {

    @Autowired
    private VehicleWarnMqHandlerService vehicleWarnMqHandlerService;

    @RabbitListener(queues = RabbitKeyVehicleWarnConstants.TRUCK_WARN_QUEUE)
    public void process(Message message) {
        try{
            log.info("车辆预警-运单预警, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<VehicleWarnTruckWarnMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("车辆预警-运单预警 失败",e);
        }
    }

    private void process(VehicleWarnTruckWarnMqParam mq){

        vehicleWarnMqHandlerService.truckWarn(mq);

    }
}
