package com.clx.performance.listener.trace;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyTraceConstants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 轨迹 mq
 * @Date: 2023-10-20 10:30:49
 * @Version: 1.0
 */
@Slf4j
@Component
public class TraceDelayListener {
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @RabbitListener(queues = RabbitKeyTraceConstants.DEFAULT_DEAD_QUEUE)
    public void process(Message message) {
        try{
            log.info("轨迹-延迟, message:{}", message);
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<MqDelay>>(){}).getData());
        }catch (Exception e){
            log.info("轨迹-延迟 失败",e);
        }
    }

    void process(MqDelay mq){
        Message message = MessageBuilder.withBody(JSON.toJSONString(mq.getData()).getBytes()).build();
        rabbitTemplate.send(mq.getExchange(), mq.getRouterKey(), message);
    }

}
