package com.clx.performance.job.settlement;

import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.utils.JobHandlerService;
import com.msl.common.utils.DateUtils;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Component
public class DriverSettlementJob {

    @Autowired
    private JobHandlerService jobHandlerService;

    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;

    @Autowired
    private SettlementMqHandlerService settlementMqHandlerService;

    /**
     * 车主结算单支付 (每天凌晨2点)
     */
    @XxlJob("driverSettlementPay")
    public void driverSettlementPay() {
        LocalDateTime beginTime = LocalDateTime.now().minusMonths(1);
        log.info("查询未结算的车主结算单,查询开始时间:{}", DateUtils.formatDateTime(beginTime));
        jobHandlerService.handler("车主结算单-支付", ()->{
            List<SettlementDriverDetail> list = settlementDriverDetailDao.listUnPay(beginTime);
            log.info("车主结算单支付，数量:{}", list.size());
            for (SettlementDriverDetail item : list) {
                jobHandlerService.subHandler("车主结算单-支付", item, settlementMqHandlerService::paySettlementDriver);
            }
        });
    }
}
