package com.clx.performance.extranal.user;

import com.clx.user.vo.app.driver.truck.DriverTruckAppVo;
import com.msl.common.base.Optional;
import com.msl.user.param.user.external.PageProductUsersParam;
import com.msl.user.vo.company.external.ListUserCompanyVo;
import com.msl.user.vo.user.UserVo;
import com.msl.user.vo.user.external.PageProductUserVo;
import com.msl.user.vo.user.external.UserDetailInfoVo;

import java.util.List;

/**
 * @Author liumingchao
 * @Date 2023/7/12 11:23
 */
public interface UserService {

    /**
     * 根据用户编号查询用户信息
     */
    Optional<UserVo> getUserByNo(Long userNo, boolean containDeleted);

    /**
     * 根据用户编号查询实名认证信息
     */

    Optional<List<PageProductUserVo>> pageProductUsers(PageProductUsersParam param);

    Optional<UserDetailInfoVo> getUserDetailInfo(Long userNo);

    void bindUserProduct(Long userNo, String productCode);

    Optional<List<ListUserCompanyVo>> listUserCompany(Long userNo);

    Optional<List<DriverTruckAppVo>> driverTruckList(Long userNo);

}
