package com.clx.performance.dao.impl.loan;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.loan.BorrowerConfigDao;
import com.clx.performance.enums.loan.BorrowerConfigEnum;
import com.clx.performance.mapper.loan.BorrowerConfigMapper;
import com.clx.performance.model.loan.BorrowerConfig;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerConfigParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerConfigVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 借款配置
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
@Repository
public class BorrowerConfigDaoImpl extends BaseDaoImpl<BorrowerConfigMapper, BorrowerConfig, Integer> implements BorrowerConfigDao {


    @Override
    public boolean update(BorrowerConfig item) {
        return update(lUdWrapper()
                .eq(BorrowerConfig::getId, item.getId())
                .set(BorrowerConfig::getBorrowerId, item.getBorrowerId())
                .set(BorrowerConfig::getBorrowerName, item.getBorrowerName())
                .set(BorrowerConfig::getType, item.getType())
                .set(BorrowerConfig::getDay, item.getDay())

                .set(BorrowerConfig::getOpUserNo, item.getOpUserNo())
                .set(BorrowerConfig::getOpUserName, item.getOpUserName())
                .set(BorrowerConfig::getOpTime, item.getOpTime())
        );
    }

    @Override
    public boolean updateStatus(BorrowerConfig item) {
        return update(lUdWrapper()
                .eq(BorrowerConfig::getId, item.getId())
                .set(BorrowerConfig::getStatus, item.getStatus())

                .set(BorrowerConfig::getOpUserNo, item.getOpUserNo())
                .set(BorrowerConfig::getOpUserName, item.getOpUserName())
                .set(BorrowerConfig::getOpTime, item.getOpTime())
        );
    }

    @Override
    public boolean updateDelete(BorrowerConfig item) {
        return update(lUdWrapper()
                .eq(BorrowerConfig::getId, item.getId())
                .set(BorrowerConfig::getDeleteStatus, item.getDeleteStatus())

                .set(BorrowerConfig::getOpUserNo, item.getOpUserNo())
                .set(BorrowerConfig::getOpUserName, item.getOpUserName())
                .set(BorrowerConfig::getOpTime, item.getOpTime())
        );
    }

    @Override
    public boolean updateName(Integer borrowerId, String borrowerName) {
        return baseMapper.updateName(borrowerId, borrowerName) > 0;
    }

    @Override
    public Optional<BorrowerConfig> selectByBorrowerIdAndType(Integer borrowerId, Integer type) {
        return Optional.of(borrowerId)
                .map(item -> lQrWrapper()
                        .eq(BorrowerConfig::getBorrowerId, item)
                        .eq(BorrowerConfig::getType, type)
                        .eq(BorrowerConfig::getDeleteStatus, BorrowerConfigEnum.DeleteStatus.NO.getCode())
                        .last("limit 1")
                )
                .map(super::getOne);
    }

    @Override
    public List<BorrowerConfig> listEnable() {
        return list(lQrWrapper()
                .eq(BorrowerConfig::getDeleteStatus, BorrowerConfigEnum.DeleteStatus.NO.getCode())
                .eq(BorrowerConfig::getStatus, BorrowerConfigEnum.Status.ENABLE.getCode())
        );
    }

    @Override
    public IPage<BorrowerConfigVO> pageByParam(PageBorrowerConfigParam param) {
        Page<BorrowerConfigVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }
}
