package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.enums.DeleteStatusEnum;
import com.clx.performance.dao.PlatformAccountConfigDao;
import com.clx.performance.enums.PlatformAccountConfigEnum;
import com.clx.performance.mapper.PlatformAccountConfigMapper;
import com.clx.performance.model.PlatformAccountConfig;
import com.clx.performance.param.pc.carrier.PagePlatformAccountConfigParam;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Objects;

/**
 * @Author: 姜文业
 * @Description: 平台账户配置
 * @Date: 2024-01-25 18:04:09
 * @Version: 1.0
 */
@Repository
public class PlatformAccountConfigImpl extends BaseDaoImpl<PlatformAccountConfigMapper, PlatformAccountConfig, Integer> implements PlatformAccountConfigDao {

    @Override
    public IPage<PlatformAccountConfig> pagePlatformAccountConfig(PagePlatformAccountConfigParam param) {
        LambdaQueryWrapper<PlatformAccountConfig> query = new LambdaQueryWrapper<>();
        query.eq(PlatformAccountConfig :: getDeleteStatus, DeleteStatusEnum.NO.getCode());
        if(Objects.nonNull(param.getBusinessType())){
            query.eq(PlatformAccountConfig :: getBusinessType,param.getBusinessType());
        }
        if(Objects.nonNull(param.getOwnerType())){
            query.eq(PlatformAccountConfig :: getOwnerType,param.getOwnerType());
        }
        query.orderByDesc(PlatformAccountConfig :: getModifiedTime);
        return baseMapper.selectPage(Page.of(param.getPage(),param.getPageSize()),query);
    }

    @Override
    public boolean deletePlatformAccountConfig(Integer id) {
        return update(lUdWrapper()
                .eq(PlatformAccountConfig::getId, id)
                .set(PlatformAccountConfig::getDeleteStatus, DeleteStatusEnum.YES.getCode())
        );
    }

    @Override
    public boolean updatePlatformAccountConfig(PlatformAccountConfig config) {
        return update(lUdWrapper()
                .eq(PlatformAccountConfig::getId, config.getId())
                .set(PlatformAccountConfig::getBusinessType, config.getBusinessType())
                .set(PlatformAccountConfig::getOwnerType, config.getOwnerType())
                .set(PlatformAccountConfig::getInvoiceType, config.getInvoiceType())
                .set(PlatformAccountConfig::getInvoiceCompanyId, config.getInvoiceCompanyId())
                .set(PlatformAccountConfig::getInvoiceCompanyName, config.getInvoiceCompanyName())
                .set(PlatformAccountConfig::getConfigRange, config.getConfigRange())
                .set(PlatformAccountConfig::getCompanyName, config.getCompanyName())
                .set(PlatformAccountConfig::getBankName, config.getBankName())
                .set(PlatformAccountConfig::getOpenBank, config.getOpenBank())
                .set(PlatformAccountConfig::getBankCode, config.getBankCode())
                .set(PlatformAccountConfig::getBankCardNo, config.getBankCardNo())
                .set(PlatformAccountConfig::getModifiedUserNo, config.getModifiedUserNo())
                .set(PlatformAccountConfig::getModifiedUserName, config.getModifiedUserName())
        );
    }

    @Override
    public List<PlatformAccountConfig> checkPlatformAccountConfigOnly(PlatformAccountConfig config) {
        LambdaQueryWrapper<PlatformAccountConfig> query = new LambdaQueryWrapper<>();
        query.eq(PlatformAccountConfig :: getDeleteStatus, DeleteStatusEnum.NO.getCode());
        if(Objects.equals(config.getBusinessType(), PlatformAccountConfigEnum.BusinessType.SETTLE.getCode())){
            query.eq(PlatformAccountConfig :: getBusinessType, config.getBusinessType());
            query.eq(PlatformAccountConfig :: getOwnerType, config.getOwnerType());
            query.eq(PlatformAccountConfig :: getInvoiceType, config.getInvoiceType());
            query.eq(PlatformAccountConfig :: getInvoiceCompanyId, config.getInvoiceCompanyId());
            query.eq(PlatformAccountConfig :: getConfigRange, config.getConfigRange());
        }
        if(Objects.equals(config.getBusinessType(), PlatformAccountConfigEnum.BusinessType.BREAK.getCode())){
            query.eq(PlatformAccountConfig :: getBusinessType, config.getBusinessType());
            query.eq(PlatformAccountConfig :: getOwnerType, config.getOwnerType());
            query.eq(PlatformAccountConfig :: getInvoiceCompanyId, config.getInvoiceCompanyId());
            query.eq(PlatformAccountConfig :: getConfigRange, config.getConfigRange());
        }
        if(Objects.equals(config.getBusinessType(), PlatformAccountConfigEnum.BusinessType.RECHARGE.getCode())){
            query.eq(PlatformAccountConfig :: getBusinessType, config.getBusinessType());
            query.eq(PlatformAccountConfig :: getOwnerType, config.getOwnerType());
        }
        if(Objects.equals(config.getBusinessType(), PlatformAccountConfigEnum.BusinessType.WITHDRAWAL.getCode())){
            query.eq(PlatformAccountConfig :: getBusinessType, config.getBusinessType());
            query.eq(PlatformAccountConfig :: getOwnerType, config.getOwnerType());
        }
        return baseMapper.selectList(query);
    }

    @Override
    public List<PlatformAccountConfig> getPlatformAccountConfigByType(Integer businessType,
                                                                      Integer ownerType,
                                                                      Integer invoiceType,
                                                                      Integer invoiceCompanyId,
                                                                      Integer configRange){
        LambdaQueryWrapper<PlatformAccountConfig> query = new LambdaQueryWrapper<>();
        query.eq(PlatformAccountConfig :: getDeleteStatus, DeleteStatusEnum.NO.getCode());
        if(Objects.nonNull(businessType)){
            query.eq(PlatformAccountConfig :: getBusinessType, businessType);
        }
        if(Objects.nonNull(ownerType)){
            query.eq(PlatformAccountConfig :: getOwnerType, ownerType);
        }
        if(Objects.nonNull(invoiceCompanyId)){
            query.eq(PlatformAccountConfig :: getInvoiceCompanyId, invoiceCompanyId);
        }
        if(Objects.nonNull(configRange)){
            query.eq(PlatformAccountConfig :: getConfigRange, configRange);
        }
        if(Objects.nonNull(invoiceType)){
            query.eq(PlatformAccountConfig :: getInvoiceType, invoiceType);
        }
        return baseMapper.selectList(query);
    }
}
