package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderGoodsAdjustmentPriceDao;
import com.clx.performance.mapper.OrderGoodsAdjustmentPriceMapper;
import com.clx.performance.model.OrderGoodsAdjustmentPrice;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2024-07-18
 * Time 17:04
 */
@Repository
public class OrderGoodsAdjustmentPriceDaoImpl extends BaseDaoImpl<OrderGoodsAdjustmentPriceMapper, OrderGoodsAdjustmentPrice, Integer> implements OrderGoodsAdjustmentPriceDao {
    @Override
    public List<OrderGoodsAdjustmentPrice> selectByOrderNoList(List<String> orderNoList) {
        return baseMapper.selectList(lQrWrapper().in(OrderGoodsAdjustmentPrice::getOrderNo, orderNoList)
                .orderByAsc(OrderGoodsAdjustmentPrice :: getCreateTime)
        );
    }
}
