package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderChildPoundAuditDao;
import com.clx.performance.mapper.OrderChildPoundAuditMapper;
import com.clx.performance.model.OrderChildPoundAudit;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 磅单审核表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildPoundAuditDaoImpl extends BaseDaoImpl<OrderChildPoundAuditMapper, OrderChildPoundAudit, Integer> implements OrderChildPoundAuditDao {
    @Override
    public Optional<OrderChildPoundAudit> getPoundAuditDetail(String childNo) {
        return Optional.ofNullable(super.getOne(lQrWrapper()
                .eq(OrderChildPoundAudit::getChildNo, childNo)
                .orderByDesc(OrderChildPoundAudit::getId)
                .last("limit 1")));
    }

    @Override
    public List<OrderChildPoundAudit> getPoundAuditList(String childNo) {
        return super.list(lQrWrapper()
                .eq(OrderChildPoundAudit::getChildNo, childNo)
                .orderByDesc(OrderChildPoundAudit::getId));
    }
}
