package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.owner.PageCarrierSettlementPlatformServiceFeeParam;
import com.clx.performance.service.settle.SettlementPlatformServiceFeeExportService;
import com.clx.performance.service.settle.SettlementPlatformServiceFeeService;
import com.clx.performance.vo.pc.carrier.settle.SettlementPlatformServiceFeeVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlement/platformServiceFee")
@Validated
@Api(tags = "承运端-平台服务费统计-平台服务费")
public class CarrierSettlementPlatformServiceFeeController {
    @Autowired
    private SettlementPlatformServiceFeeService settlementPlatformServiceFeeService;
    @Autowired
    private SettlementPlatformServiceFeeExportService settlementPlatformServiceFeeExportService;

    @ApiOperation(value = "平台服务费统计",notes = "<br>By:艾庆国")
    @PostMapping("/pagePlatformServiceFee")
    @UnitCovert(param = false)
    public Result<PageData<SettlementPlatformServiceFeeVO>> pagePlatformServiceFee(
            @RequestBody @Validated PageCarrierSettlementPlatformServiceFeeParam param) {
        IPage<SettlementPlatformServiceFeeVO> page  = settlementPlatformServiceFeeService
                .pagePlatformServiceFee(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


    @ApiOperation(value = "导出平台服务费统计",notes = "<br>By:艾庆国")
    @PostMapping("/exportPlatformServiceFee")
    public void exportPlatformServiceFee(@RequestBody @Validated PageCarrierSettlementPlatformServiceFeeParam param) {

        settlementPlatformServiceFeeExportService.exportPlatformServiceFee(param);
    }

}
