package com.clx.performance.vo.pc.loan.owner;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 货主借款账户
* @Date: 2024/01/22 18:17:57
* @Version: 1.0
*/

@ApiModel(description = "货主借款账户")
@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class OwnerAccountVO {

    @ApiModelProperty(value = "货主编码", example = "10000000")
    private Long ownerUserNo;
    @ApiModelProperty(value = "货主名称", example = "张三")
    private String ownerUserName;
    @ApiModelProperty(value = "联系电话", example = "13000000000")
    private String mobile;
    @ApiModelProperty(value = "默认 3：借款账户", example = "3")
    private Integer accountType;
    @ApiModelProperty(value = "是否开通借款账户 0：未开通  1：已开通", example = "3")
    private Integer openAccount;


    @ApiModelProperty(value = "可用余额 (元) ", example = "1.23")
    private BigDecimal amount;
    public BigDecimal getAmount() {
        return BigDecimal.ZERO.add(fundingUsableBalance==null? BigDecimal.ZERO : fundingUsableBalance).add(virtuallyUsableBalance==null? BigDecimal.ZERO : virtuallyUsableBalance);
    }

    @ApiModelProperty(value = "冻结金额(元) ", example = "1.23")
    private BigDecimal frozenAmount;
    public BigDecimal getFrozenAmount() {
        return BigDecimal.ZERO.add(fundingFrozenBalance==null? BigDecimal.ZERO : fundingFrozenBalance).add(virtuallyFrozenBalance==null? BigDecimal.ZERO : virtuallyFrozenBalance);
    }

    @ApiModelProperty(value = "欠款金额 (元)", example = "1.23")
    private BigDecimal arrears;
    public BigDecimal getArrears() {
        return BigDecimal.ZERO.add(fundingArrears==null? BigDecimal.ZERO : fundingArrears).add(virtuallyArrears==null? BigDecimal.ZERO : virtuallyArrears);
    }






    @JsonIgnore
    @ApiModelProperty(value = "资金账户余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingAccountBalance;
    @JsonIgnore
    @ApiModelProperty(value = "资金可用余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingUsableBalance;
    @JsonIgnore
    @ApiModelProperty(value = "资金冻结余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingFrozenBalance;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币账户余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyAccountBalance;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币可用余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyUsableBalance;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币冻结余额", example = "", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyFrozenBalance;

    @JsonIgnore
    @ApiModelProperty(value = "资金欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal fundingArrears;
    @JsonIgnore
    @ApiModelProperty(value = "虚拟币欠款", example = "1.23", hidden = true)
    @MoneyOutConvert
    private BigDecimal virtuallyArrears;

}