package com.clx.performance.vo.pc.loan.carrier;

import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CarrierOwnerPaymentVO{

    private Integer id;
   
    @ApiModelProperty("付款金额")
    @MoneyOutConvert
    private BigDecimal paymentBalance;

    @ApiModelProperty("付款方")
    private String payment;

    @ApiModelProperty("付款账户")
    private String paymentAccount;

    @ApiModelProperty("收款方")
    private String payee;

    @ApiModelProperty("收款账户")
    private String payeeAccount;

}
