package com.clx.performance.vo.pc.loan.carrier;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 借出方
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@ApiModel(description = "借出方")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BorrowerVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "借出方", example = "1")
    private String name;
    @ApiModelProperty(value = "所属银行", example = "工商银行")
    private String bankName;
    @ApiModelProperty(value = "银行账号", example = "1111111111111111")
    private String bankCardNo;
    @ApiModelProperty(value = "开户行行号", example = "313332082914")
    private String openBankId;
    @ApiModelProperty(value = "开户行", example = "宁波银行")
    private String openBankName;
    @ApiModelProperty(value = "状态：1启用 2禁用", example = "1")
    private Integer status;
    @ApiModelProperty(value = "操作人编码", example = "1000000")
    private Long opUserNo;
    @ApiModelProperty(value = "操作人", example = "张三")
    private String opUserName;
    @ApiModelProperty(value = "操作时间", example = "")
    private String opTime;
    @ApiModelProperty(value = "创建人编号", example = "1000000")
    private Long createBy;
    @ApiModelProperty(value = "创建人名称", example = "张三")
    private String createName;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

}