package com.clx.performance.vo.pc.broker;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderChildDTO {

    private String sourceChildNo;
    @ApiModelProperty(value = "源货单编号", example = "1234", required = true, dataType = "String")
    private String sourceGoodsNo;
    @ApiModelProperty(value = "源订单编号", example = "1234", required = true, dataType = "String")
    private String sourceOrderNo;
    @ApiModelProperty(value = "源结算单编号", example = "1234", required = true, dataType = "String")
    private String sourceSettlementNo;

    @ApiModelProperty(value = "运费单价（分/吨）", example = "162", required = true, dataType = "Integer")
    private Integer freightPrice;
    @ApiModelProperty(value = "运费（分）", example = "162", required = true, dataType = "Integer")
    private Integer freight;
    @ApiModelProperty(value = "司机运费（分）",  example = "123", dataType = "Integer")
    private Integer driverFreight;
    @ApiModelProperty(value = "司机运费单价（分/吨）",  example = "123", dataType = "Integer")
    private Integer driverFreightPrice;
    @ApiModelProperty(value = "开票金额（分）", example = "162", required = true, dataType = "Integer")
    private Integer invoiceFreight;
    @ApiModelProperty(value = "亏吨扣款（分）",  example = "123", dataType = "Integer")
    private Integer lossFee;
    @ApiModelProperty(value = "货损单价（分/吨）",  example = "123", dataType = "Integer")
    private Integer lossFeePrice;

    @ApiModelProperty(value = "发货皮重（吨）")
    private BigDecimal sendTare;
    @ApiModelProperty(value = "发货毛重（吨）")
    private BigDecimal sendRough;
    @ApiModelProperty(value = "发货净重（吨）")
    private BigDecimal sendNet;

    @ApiModelProperty(value = "接单时间")
    private String payTime;
    @ApiModelProperty(value = "装车时间")
    private String loadTime;
    @ApiModelProperty(value = "卸车时间")
    private String unloadTime;
    @ApiModelProperty(value = "运单完成时间", example = "2020-02-02 10:10:10", required = true, dataType = "String")
    private String payFinishedTime;
    @ApiModelProperty(value = "磅单审核时间", example = "2020-02-02 10:10:10", required = true, dataType = "String")
    private String poundTime;

    @ApiModelProperty(value = "收货皮重（吨）")
    private BigDecimal receiveTare;
    @ApiModelProperty(value = "收货毛重（吨）")
    private BigDecimal receiveRough;
    @ApiModelProperty(value = "收货净重（吨）")
    private BigDecimal receiveNet;

    @ApiModelProperty(value = "备注", example = "", required = true, dataType = "String")
    private String remark;

    @ApiModelProperty(value = "1 普通单 2 网运单", example = "1", required = true, dataType = "Integer")
    private Integer invoiceFlag;
    @ApiModelProperty(value = "线下平台", example = "华祥", required = true, dataType = "String")
    private String invoicePlatform;

    @ApiModelProperty(value = "开票状态 0 未开票 1 已开票 ", example = "1")
    private Integer invoiceStatus;

    @ApiModelProperty(value = "结算状态 1 已结算 ", example = "1234124", dataType = "String")
    private Integer settleStatus;

}
