package com.clx.performance.vo.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class OwnerLoanAccountVO {

    private Integer id;

    @ApiModelProperty("货主编码")
    private Long ownerUserNo;

    @ApiModelProperty("货主名称")
    private String ownerUserName;

    @ApiModelProperty("联系电话")
    private String mobile;

    @ApiModelProperty("账户类型： 默认3 借款账户")
    private Integer accountType;

    @ApiModelProperty("资金金额")
    private BigDecimal fundingAmount;

    @ApiModelProperty("虚拟币金额")
    private BigDecimal virtuallyAmount;

    @ApiModelProperty("资金欠款")
    private BigDecimal fundingArrears;

    @ApiModelProperty("虚拟币欠款")
    private BigDecimal virtuallyArrears;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;
}
