package com.clx.performance.param.pc.vehiclewarn;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
public class VehicleWarnInfoSuspendUpdateParam {

    @ApiModelProperty(value = "id", example = "1")
    @NotNull(message = "id不能为空")
    private Integer id;

    @ApiModelProperty(value = "预警屏蔽范围：1运单 2货单 3无预警", example = "1")
    @NotNull(message = "预警屏蔽范围不能为空")
    private Integer warnRang;
    @ApiModelProperty(value = "预警屏蔽结束时间", example = "")
    @NotBlank(message = "预警屏蔽结束时间不能为空")
    private String warnEndTime;

}
