package com.clx.performance.param.pc.linewarn;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class LineWarnConfigAddParam {

    @ApiModelProperty(value = "预警方案名称", example = "方案1")
    @NotBlank(message = "预警方案名称不能为空")
    private String warnName;
    @ApiModelProperty(value = "预警类型", example = "1")
    @NotNull(message = "预警类型不能为空")
    private Integer warnType;
    @ApiModelProperty(value = "预警级别", example = "1")
    @NotNull(message = "预警级别不能为空")
    private Integer warnLevel;

    @ApiModelProperty(value = "预警间隔（小时）", example = "1.1")
    @NotNull(message = "预警间隔不能为空")
    private BigDecimal interval;
    @ApiModelProperty(value = "时间占比（%）", example = "1.2")
    private BigDecimal timeRatio;
    @ApiModelProperty(value = "任务完成占比", example = "1.3")
    private BigDecimal taskCompleteRatio;
    @ApiModelProperty(value = "交通增加时间（分钟）", example = "1")
    private Integer congestionTime;

}
