package com.clx.performance.param.pc.carrier;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Getter
@Setter
public class SavePlatformAccountConfigParam {

    @ApiModelProperty(value = "id")
    private Integer Id;

    @NotNull(message = "应用场景不能为空")
    @ApiModelProperty(value = "应用场景 1-结算单，2-违约结算单，3-充值，4-提现")
    private Integer businessType;

    @NotNull(message = "货主类型不能为空")
    @ApiModelProperty(value = "货主类型 1-企业，2-个人")
    private Integer ownerType;

    @ApiModelProperty(value = "开票标识：1网运单 2普通单")
    private Integer invoiceType;

    @ApiModelProperty(value = "开票公司id")
    private Integer invoiceCompanyId;

    @ApiModelProperty(value = "开票公司名称")
    private String invoiceCompanyName;

    @NotNull(message = "配置范围不能为空")
    @ApiModelProperty(value = "配置范围：1收款账户 2付款账户")
    private Integer configRange;


    @NotBlank(message = "公司名称不能为空")
    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @NotBlank(message = "银行名称不能为空")
    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @NotBlank(message = "开户行不能为空")
    @ApiModelProperty(value = "开户行")
    private String openBank;

    @NotBlank(message = "银行编码不能为空")
    @ApiModelProperty(value = "银行编码")
    private String bankCode;

    @NotBlank(message = "银行账号不能为空")
    @ApiModelProperty(value = "银行账号")
    private String bankCardNo;

}
