package com.clx.performance.param.pc;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @Author liruixin
 * @create 2023-09-19 13:33
 */
@Getter
@Setter
@NoArgsConstructor
@ToString
public class PoundAuditParam  {

    @NotBlank(message = "运单编号不能为空")
    @ApiModelProperty(value="运单编号",example = "CYD201457878")
    private String childNo;

    @ApiModelProperty(value="审核驳回类型：1装车 2卸车 3装车+卸车",example = "1")
    private Integer rejectType;

    @ApiModelProperty(value="驳回原因",example = "驳回原因")
    private String remark;

    @NotNull(message = "审核状态不能为空")
    @ApiModelProperty(value="审核状态 0 待审核 1 审核通过 2 审核驳回",example = "1")
    private Integer status;

    @ApiModelProperty(value = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @ApiModelProperty(value="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @ApiModelProperty(value="卸货皮重",example = "41")
    private BigDecimal unloadTare;




}
