package com.clx.performance.enums.settle;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;


public enum SettlementLogEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {
        CREATE_SETTLEMENT(1, "创建结算单"),
        UPLOAD_SETTLEMENT (2, "上传结算凭证"),
        OWNER_TO_BE_CONFIRMED(3, "货主确认结算单"),
        SHIPPER_TO_PAYMENT(4, "货主付款"),
        PLATFORM_CONFIRMED_OWNER_PAYMENT(5, "平台确认付款"),
        PLATFORM_TO_PAYMENT(6, "平台付款"),
        OWNER_CONFIRMED_PLATFORM_PAYMENT(7, "货主确认付款"),
        INVOICE_TO_BE_MAILED(8, "邮寄发票"),
        COMPLETED(9, "已完结"),
        PLATFORM_CONFIRM_ACCOUNT (10, "平台确认对账"),
        PLATFORM_TO_BE_CONFIRMED(11, "平台确认结算单"),
        ;

        private final Integer code;
        private final String msg;

        public static Optional<Type> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getMsg).orElse(null);
        }
    }



}
