package com.clx.performance.enums.payment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author huningning
 * Date 2024-06-18
 * Time 14:01
 * 支付状态
 */
public enum PaymentStatusEnum {
    CREATE(0, "发起"),
    SUCCESS(1, "成功"),
    FAIL(2, "失败")
    ;

    private static Map<Integer, String> map = new ConcurrentHashMap<>();
    static {
        for(PaymentStatusEnum paymentStatusEnum : PaymentStatusEnum.values()){
            map.put(paymentStatusEnum.getValue(), paymentStatusEnum.getDisplayValue());
        }
    }
    private int value;
    private String displayValue;

    public void setValue(int value) {
        this.value = value;
    }

    public String getDisplayValue() {
        return displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    private PaymentStatusEnum(int value, String displayValue){
        this.value = value;
        this.displayValue = displayValue;
    }
    public int getValue(){
        return value;
    }
    public static String toString(int value){
        return map.get(value);
    }
}
