package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author yangqifa
 */
@Getter
@AllArgsConstructor
public enum PlatformServiceFeeConfigEnum {

    /**
     * 未税
     */
    TAX_EXCLUDED(0, "未税"),
    /**
     * 含税
     */
    TAX_INCLUDED(1, "含税");

    private final Integer code;
    private final String msg;

    public static Optional<PlatformServiceFeeConfigEnum> getByCode(int code) {
        return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
    }

    public static String getMsgByCode(int code) {
        return getByCode(code).map(PlatformServiceFeeConfigEnum::getMsg).orElse(null);
    }
}
