package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum PlatformAccountConfigEnum {
    ;
    @Getter
    @AllArgsConstructor
    public enum InvoiceType {
        ONLINE(1, "网运单"),
        ORDINARY(2, "普通单");
        private final Integer code;
        private final String msg;

        public static Optional<InvoiceType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(InvoiceType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum BusinessType {
        SETTLE(1, "结算单"),
        BREAK(2, "违约结算单"),
        RECHARGE(3, "充值"),
        WITHDRAWAL(4, "提现");
        private final Integer code;
        private final String msg;

        public static Optional<BusinessType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(BusinessType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum OwnerType {
        COMPANY(1, "企业"),
        PERSON(2, "个人");
        private final Integer code;
        private final String msg;

        public static Optional<OwnerType> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(OwnerType::getMsg).orElse(null);
        }
    }

    @Getter
    @AllArgsConstructor
    public enum ConfigRange {
        COLLECTION(1, "收款账户"),
        PAY(2, "付款账户");
        private final Integer code;
        private final String msg;

        public static Optional<ConfigRange> getByCode(int code) {
            return Arrays.stream(values()).filter(e -> Objects.equals(e.getCode(), code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(ConfigRange::getMsg).orElse(null);
        }
    }

}
