package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum OrderChildImageEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type {

        LOAD(1, "装车图片"),

        UNLOAD(2, "卸车图片"),

        WEIGHT_IN(3, "进场图片"),
        WEIGHT_OUT(4, "出场图片"),


        ;

        private final Integer code;
        private final String name;

        public static Optional<Type> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Type::getName).orElse(null);
        }
    }


}
