package com.clx.performance.sqlProvider;

import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.param.pc.ArtificialCancelOrderQueryParam;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@RunWith(JUnit4.class)
public class OrderChildSqlProviderTest {

    @Test
    public void testFindArtificialCancelOrderWithParams() {
        ArtificialCancelOrderQueryParam param = new ArtificialCancelOrderQueryParam();
        param.setOrderChildNo("testChildNo");
        param.setTruckNo("testTruckNo");

        OrderChildSqlProvider orderChildSqlProvider = new OrderChildSqlProvider();
        String sql = orderChildSqlProvider.findArtificialCancelOrder(param);

        String expectedSql = "SELECT child_no, goods_name, freight_price, order_no, "
                + "send_address, receive_address, "
                + "driver_user_no, driver_name, driver_mobile, "
                + "truck_no, unload_pound_no, weight, "
                + "cancel_remark, pound_status, status, "
                + "DATE_FORMAT(load_deadline, '%Y-%m-%d %H:%i:%s') AS loadDeadline, "
                + "DATE_FORMAT(create_time, '%Y-%m-%d %H:%i:%s') AS createTime, "
                + "DATE_FORMAT(unload_time, '%Y-%m-%d %H:%i:%s') AS unloadTime "
                + "FROM order_child "
                + "WHERE 1=1 "
                + "AND child_no = #{param.orderChildNo} "
                + "AND truck_no = #{param.truckNo} "
                + "AND status IN (10, 30, 40, 50, 60, 70, 80)";

        Assert.assertEquals("SQL statement does not match expected output", expectedSql, sql);
    }

    @Test
    public void testFindArtificialCancelOrderWithoutParams() {
        ArtificialCancelOrderQueryParam param = new ArtificialCancelOrderQueryParam();
        OrderChildSqlProvider orderChildSqlProvider = new OrderChildSqlProvider();
        String sql = orderChildSqlProvider.findArtificialCancelOrder(param);

        List<Integer> statusList = Arrays.asList(
                OrderChildEnum.Status.CREATED.getCode(),
                OrderChildEnum.Status.GO_TO_SEND.getCode(),
                OrderChildEnum.Status.ARRIVE_SEND.getCode(),
                OrderChildEnum.Status.LOAD.getCode(),
                OrderChildEnum.Status.GO_TO_RECEIVE.getCode(),
                OrderChildEnum.Status.ARRIVE_RECEIVE.getCode(),
                OrderChildEnum.Status.UNLOAD.getCode()
        );
        String expectedSql = "SELECT child_no, goods_name, freight_price, order_no, "
                + "send_address, receive_address, "
                + "driver_user_no, driver_name, driver_mobile, "
                + "truck_no, unload_pound_no, weight, "
                + "cancel_remark, pound_status, status, "
                + "DATE_FORMAT(load_deadline, '%Y-%m-%d %H:%i:%s') AS loadDeadline, "
                + "DATE_FORMAT(create_time, '%Y-%m-%d %H:%i:%s') AS createTime, "
                + "DATE_FORMAT(unload_time, '%Y-%m-%d %H:%i:%s') AS unloadTime "
                + "FROM order_child "
                + "WHERE 1=1 "
                + "AND status IN (" + String.join(", ", statusList.stream().map(String::valueOf).collect(Collectors.toList())) + ")";

        Assert.assertEquals("SQL statement does not match expected output for empty parameters", expectedSql, sql);
    }
}