package com.clx.performance;

import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.clx.performance.dao.OwnerAccountDao;
import com.clx.performance.param.pc.PageOwnerAccountListParam;
import com.clx.performance.service.impl.OwnerAccountServiceImpl;
import com.clx.performance.vo.pc.OwnerAccountVO;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import static org.mockito.Mockito.when;

@RunWith(MockitoJUnitRunner.class)
public class OwnerAccountServiceImplTest {

    @Mock
    private OwnerAccountDao ownerAccountDao;

    @InjectMocks
    private OwnerAccountServiceImpl ownerAccountService;

    private PageOwnerAccountListParam param;

    @Before
    public void setUp() {
        param = new PageOwnerAccountListParam();
        // Assuming there's a default page size set in PageOwnerAccountListParam
        param.setPageSize(10);
        param.setPage(1);
    }

    @Test
    public void testExportPrepaidFreightList() throws IOException {
        List<OwnerAccountVO> records = new ArrayList<>();
        OwnerAccountVO accountVO = new OwnerAccountVO();
        accountVO.setId(18);
        accountVO.setOwnerUserNo("188888");
        accountVO.setOwnerUserName("owner88");
        accountVO.setMobile("18888888888");
        accountVO.setAccountType(1);
        accountVO.setAccountBalance(new BigDecimal("8888.88"));
        accountVO.setUsableBalance(new BigDecimal("8888.88"));
        accountVO.setFrozenBalance(new BigDecimal("8888.88"));
        accountVO.setCreateBy("domino.j");
        accountVO.setCreateTime("2024-08-07 14:15:18");
        accountVO.setModifiedTime("2024-08-07 14:15:18");
        records.add(accountVO);

        PageDTO page = new PageDTO(1, 10000);
        page.setRecords(records);

        // Mock the behavior of the ownerAccountDao
        when(ownerAccountDao.pageList(param)).thenReturn(page);

        // Perform the test
        SXSSFWorkbook workbook = ownerAccountService.exportPrepaidFreightList(param);

        workbook.write(new java.io.FileOutputStream("ccc.xlsx"));
    }

}