package com.clx.performance.utils.zjxl;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.exception.ExceptionUtils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

/**
 * @ClassName ZJXLPositionUtils
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:11
 * @Version 1.0
 */
@Slf4j
public class ZJXLPositionUtils {
    public ZJXLPositionUtils() {
    }

    public static BigDecimal[] WGS484Format(String lon, String lat) {
        BigDecimal ratio = new BigDecimal("600000");
        BigDecimal lonNew = (new BigDecimal(lon)).divide(ratio, 10, 4);
        BigDecimal latNew = (new BigDecimal(lat)).divide(ratio, 10, 4);
        return new BigDecimal[]{lonNew, latNew};
    }

    public static String gpsTimeFormat(String time) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd/HHmmss");

        try {
            return sdf1.format(sdf.parse(time));
        } catch (ParseException var4) {
            log.error(ExceptionUtils.getStackTrace(var4));
            return null;
        }
    }

    public static BigDecimal speedFormat(String speed) {
        return (new BigDecimal(speed)).divide(BigDecimal.valueOf(10L), 1, 4);
    }

    public static BigDecimal mileageFormat(String mileage) {
        return (new BigDecimal(mileage)).divide(BigDecimal.valueOf(10L), 1, 4);
    }
}
