package com.clx.performance.struct.trace;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.esplus.model.TruckLatestPosESPlus;
import com.clx.performance.esplus.model.TruckTraceESPlus;
import com.clx.performance.vo.pc.trace.DriverTruckTraceVO;
import com.msl.common.utils.DateStructUtil;
import com.msl.common.utils.DateUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(componentModel = "spring", uses = DateStructUtil.class, imports = {DateUtils.class})
public interface TruckTraceStruct {

    @Mapping(target = "longitude", expression = "java(item.getLocation()[0])")
    @Mapping(target = "latitude", expression = "java(item.getLocation()[1])")
    DriverTruckTraceVO convert(TruckTraceESPlus item);
    List<DriverTruckTraceVO> convert(List<TruckTraceESPlus> list);
    Page<DriverTruckTraceVO> convertPage(IPage<TruckTraceESPlus> page);


    TruckLatestPosESPlus convert2LatestPos(TruckTraceESPlus item);

}
