package com.clx.performance.sqlProvider.loan;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanRecordOfOwner;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanRecordVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OwnerLoanRecordSqlProvider {

    public String pageByParam(@Param("page") Page<OwnerLoanRecordVO> page, @Param("param") PageOwnerLoanRecordOfOwner param) {
        return new SQL(){{

            SELECT(" id, owner_user_no as ownerUserNo, owner_user_name as ownerUserName, mobile, " +
                    " goods_name as goodsName, " +
                    " running_water_open_no as runningWaterOpenNo, merchant_running_water_no as merchantRunningWaterNo, " +
                    " loan_no as loanNo, loan_type as loanType, loan_balance as loanBalance, " +
                    " borrower, borrower_account as borrowerAccount, remittance_identification_code as remittanceIdentificationCode, " +
                    " lending_party as lendingParty, lending_party_account as lendingPartyAccount, " +
                    " payee, payee_account as payeeAccount, " +
                    " status, " +
                    " date_format(approve_time, '%Y-%m-%d %H:%i:%s') as approveTime, approve_by as approveBy, " +
                    " reject_reason as rejectReason, date_format(loan_repayment_time, '%Y-%m-%d %H:%i:%s') as loanRepaymentTime, " +
                    " pay_channel as payChannel, close_order_time as closeOrderTime, " +
                    " create_by as createBy, " +
                    " date_format(create_time, '%Y-%m-%d %H:%i:%s') as createTime, " +
                    " date_format(modified_time, '%Y-%m-%d %H:%i:%s') as modifiedTime "
            );

            FROM("owner_loan_record");
            WHERE("owner_user_no = #{param.ownerUserNo}");

            if (Objects.nonNull(param.getLoanNo())) {WHERE("loan_no = #{param.loanNo}");}
            if (StringUtils.isNotBlank(param.getRunningWaterOpenNo())) {WHERE("running_water_open_no = #{param.runningWaterOpenNo}");}
            if (Objects.nonNull(param.getLoanType())) {WHERE("loan_type = #{param.loanType}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

}
