package com.clx.performance.service.impl;

import com.alibaba.fastjson.JSON;
import com.clx.performance.dao.ThirdPartRequestLogDao;
import com.clx.performance.enums.ThirdRequestStatusEnum;
import com.clx.performance.model.ThirdPartRequestLog;
import com.clx.performance.service.ThirdPartRequestLogService;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ThirdPartRequestLogServiceImpl implements ThirdPartRequestLogService {

    @Autowired
    ThirdPartRequestLogDao thirdPartRequestLogDao;
    @Override
    public void save(ThirdPartRequestLog log) {
        thirdPartRequestLogDao.saveEntity(log);
    }

    @Override
    public void updateResult(Integer logId, Result<?> result) {
        thirdPartRequestLogDao.updateEntityByKey(new ThirdPartRequestLog()
                .setId(logId)
                .setResponseContent(JSON.toJSONString(result))
                .setStatusCode(result.getCode())
                .setStatus(result.succeed() ? ThirdRequestStatusEnum.SUCCESS.getCode() : ThirdRequestStatusEnum.FAIL.getCode()));
    }

    /**
     * 修改重试次数
     *
     * @param logId
     * @param retryTimes
     */
    @Override
    public void updateLogRetryTimes(Integer logId, Integer retryTimes) {
        thirdPartRequestLogDao.updateLogRetryTimes(logId, retryTimes);
    }

    /**
     * 根据id 查询
     *
     * @param id
     */
    @Override
    public Optional<ThirdPartRequestLog> getById(Integer id) {
        return thirdPartRequestLogDao.getEntityByKey(id);
    }
}
