package com.clx.performance.service.impl;

import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.service.OrderGoodsWeightService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * @ClassName OrderGoodsWeightServiceImpl
 * @Description
 * @Author kavin
 * @Date 2024/8/5 14:16
 * @Version 1.0
 */
@Slf4j
@Service
@AllArgsConstructor
public class OrderGoodsWeightServiceImpl implements OrderGoodsWeightService {

    private final OrderGoodsDao orderGoodsDao;
    @Override
    public BigDecimal getOrderGoodsCanExtractWeight(String orderGoodsNo) {
        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderGoodsNo).orElseThrow(ResultEnum.DATA_NOT_FIND);
        return orderGoods.getExtractWeight().subtract(orderGoods.getAlreadyTransportWeight());
    }
}
