package com.clx.performance.model.vehiclewarn;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 车辆预警配置
* @Date: 2024/04/25 13:24:56
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class VehicleWarnConfig  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String warnName;                        //预警方案名称
    private Integer warnType;                       //预警类型
    private Integer warnLevel;                      //预警级别
    @TableField(value = "`interval`")
    private BigDecimal interval;                    //预警间隔（小时）
    private BigDecimal timeoutRatio;                //超时比例（%）
    private BigDecimal longitude;                   //经度
    private BigDecimal latitude;                    //纬度
    private String address;                         //地址
    private Integer radius;                         //半径（米）
    private Integer deleteStatus;                   //删除状态: 0-否;1-是
    private Integer status;                         //状态：1启用 2禁用
    private String createBy;                        //创建人
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
