package com.clx.performance.model.payment;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author huningning
 * Date 2024-06-18
 * Time 14:01
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_payment")
public class OrderPayment implements HasKey<Integer>  {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @ApiModelProperty("主订单号")
    private String orderNo;

    @TableField("relation_no")
    @ApiModelProperty("业务关联单号")
    private String relationNo;

    @TableField("payment_item")
    @ApiModelProperty("交易名目")
    private String paymentItem;

    @TableField("serial_no")
    @ApiModelProperty("流水号")
    private String serialNo;

    @TableField("amount")
    @ApiModelProperty("金额")
    private Integer amount;

    @TableField("operation")
    @ApiModelProperty("1:冻结 2:调整 3:解冻 4:部分解冻 5:部分支付 6:支付")
    private Integer operation;

    @TableField("status")
    @ApiModelProperty("0: 发起，1: 成功，2:失败")
    private Integer status;

    @TableField("reason")
    @ApiModelProperty("")
    private String reason;

    @TableField("create_time")
    @ApiModelProperty("")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
