package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("performance_progress_log")
public class PerformanceProgressLog implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("operate_type")
    @ApiModelProperty("操作类型")
    private Integer operateType;

    @TableField("operate_content")
    @ApiModelProperty("操作内容")
    private String operateContent;


    @TableField("create_by")
    @ApiModelProperty("操作人编号")
    private Long createBy;

    @TableField("create_name")
    @ApiModelProperty("操作人名称")
    private String createName;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
