package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author liruixin
 * Date 2024-08-02
 * Time 15:38
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_child_weigh_picture")
public class OrderChildWeighPicture implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("child_no")
    @ApiModelProperty("运单编号")
    private String childNo;

    @TableField("type")
    @ApiModelProperty("图片类型 1进场 2出场")
    private Integer type;

    @TableField("original_img")
    @ApiModelProperty("原始磅单图")
    private String originalImg;

    @TableField("no_sign_img")
    @ApiModelProperty("不带签章磅单图")
    private String noSignImg;

    @TableField("sign_img")
    @ApiModelProperty("带签章磅单图")
    private String signImg;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
