package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.*;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 积分货单
* @Date: 2023-10-10 20:31:14
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class IntegralOrder implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private String orderGoodsNo;                    //货单编号
    private Integer sendAddressId;                  //发货地址id
    private String sendAddress;                     //发货地址
    private Integer receiveAddressId;               //收货地址id
    private String receiveAddress;                  //收货地址
    private Integer orderType;                      //货单类型：1优质单 2普通单 3流水单 4支援单
    private Integer truckEchelon;                   //车辆梯队
    private LocalDateTime createTime;                      //创建时间
    private LocalDateTime modifiedTime;                    //修改时间

    @Getter
    @AllArgsConstructor
    public enum OrderType{
        HIGH_QUALITY(1, "优质单"),
        NORMAL(2, "普通单"),
        WATER(3, "流水单"),
        SUPPORT(4, "支援单"),

        ;

        private Integer value;
        private String msg;

    }

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}