package com.clx.performance.mapper.settle;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.settle.NetworkDriverRunningWaterRecord;
import com.clx.performance.param.app.NetworkDriverPageParam;
import com.clx.performance.param.pc.PageNetworkAccountInfoListParam;
import com.clx.performance.sqlProvider.settle.NetworkDriverRunningWaterRecordProvider;
import com.clx.performance.vo.app.APPNetworkDriverRunningWaterRecordVO;
import com.clx.performance.vo.pc.NetworkDriverRunningWaterRecordVO;
import org.apache.ibatis.annotations.SelectProvider;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
public interface NetworkDriverRunningWaterRecordMapper extends BaseMapper<NetworkDriverRunningWaterRecord> {

    @SelectProvider(type = NetworkDriverRunningWaterRecordProvider.class, method = "networkDriverRunningWaterRecordDao")
    IPage<NetworkDriverRunningWaterRecordVO> networkDriverRunningWaterRecordDao(Page<NetworkDriverRunningWaterRecordVO> page, PageNetworkAccountInfoListParam param);

    @SelectProvider(type = NetworkDriverRunningWaterRecordProvider.class, method = "pageFrozenList")
    IPage<APPNetworkDriverRunningWaterRecordVO> pageFrozenList(Page<APPNetworkDriverRunningWaterRecordVO> page, NetworkDriverPageParam param);

    @SelectProvider(type = NetworkDriverRunningWaterRecordProvider.class, method = "runningWaterList")
    IPage<APPNetworkDriverRunningWaterRecordVO> runningWaterList(Page<APPNetworkDriverRunningWaterRecordVO> page, NetworkDriverPageParam param);
}
