package com.clx.performance.mapper.loan;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.loan.OwnerLoanAccount;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountParam;
import com.clx.performance.sqlProvider.loan.OwnerLoanAccountSqlProvider;
import com.clx.performance.vo.pc.loan.carrier.CarrierOwnerLoanAccountVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
public interface OwnerLoanAccountMapper extends BaseMapper<OwnerLoanAccount> {

    @Update("update owner_loan_account set funding_account_balance = funding_account_balance + #{account.fundingAccountBalance}" +
            ",funding_usable_balance = funding_usable_balance + #{account.fundingUsableBalance},funding_frozen_balance = funding_frozen_balance + #{account.fundingFrozenBalance}" +
            ",virtually_account_balance = virtually_account_balance + #{account.virtuallyAccountBalance},virtually_usable_balance = virtually_usable_balance + #{account.virtuallyUsableBalance}" +
            ",virtually_frozen_balance = virtually_frozen_balance + #{account.virtuallyFrozenBalance},funding_arrears = funding_arrears + #{account.fundingArrears},virtually_arrears = virtually_arrears + #{account.virtuallyArrears}" +
            ",modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer addAccount(@Param("account") OwnerLoanAccount account, @Param("now") String nowStr);

    @Update("update owner_loan_account set funding_account_balance = funding_account_balance - #{account.fundingAccountBalance}" +
            ",funding_usable_balance = funding_usable_balance - #{account.fundingUsableBalance},funding_frozen_balance = funding_frozen_balance + #{account.fundingFrozenBalance}" +
            ",virtually_account_balance = virtually_account_balance - #{account.virtuallyAccountBalance},virtually_usable_balance = virtually_usable_balance - #{account.virtuallyUsableBalance}" +
            ",virtually_frozen_balance = virtually_frozen_balance + #{account.virtuallyFrozenBalance},funding_arrears = funding_arrears - #{account.fundingArrears},virtually_arrears = virtually_arrears - #{account.virtuallyArrears}" +
            ",modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer subAccount(@Param("account") OwnerLoanAccount account, @Param("now") String now);

    /**
     * @see OwnerLoanAccountSqlProvider#pageByParam(Page, PageOwnerLoanAccountParam)
     */
    @SelectProvider(type = OwnerLoanAccountSqlProvider.class, method = "pageByParam")
    IPage<CarrierOwnerLoanAccountVO> pageByParam(@Param("page") Page<CarrierOwnerLoanAccountVO> page, @Param("param") PageOwnerLoanAccountParam param);

    @Update("update owner_loan_account set funding_account_balance = funding_account_balance - #{account.fundingAccountBalance}" +
            ",funding_usable_balance = funding_usable_balance - #{account.fundingUsableBalance},funding_frozen_balance = funding_frozen_balance - #{account.fundingFrozenBalance}" +
            ",virtually_account_balance = virtually_account_balance - #{account.virtuallyAccountBalance},virtually_usable_balance = virtually_usable_balance - #{account.virtuallyUsableBalance}" +
            ",virtually_frozen_balance = virtually_frozen_balance - #{account.virtuallyFrozenBalance}" +
            ",modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer childWriteOffOwnerLoanAccountCAS(@Param("account") OwnerLoanAccount account, @Param("now") String nowStr);

    @Update("update owner_loan_account set funding_account_balance = funding_account_balance + #{account.fundingAccountBalance}" +
            ",funding_usable_balance = funding_usable_balance + #{account.fundingUsableBalance},funding_frozen_balance = funding_frozen_balance - #{account.fundingFrozenBalance}" +
            ",virtually_account_balance = virtually_account_balance + #{account.virtuallyAccountBalance},virtually_usable_balance = virtually_usable_balance + #{account.virtuallyUsableBalance}" +
            ",virtually_frozen_balance = virtually_frozen_balance - #{account.virtuallyFrozenBalance}" +
            ",modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer thawOwnerLoanAccountCAS(@Param("account") OwnerLoanAccount account, @Param("now") String nowStr);
}
