package com.clx.performance.listener.broker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyBrokerConstants;
import com.clx.performance.service.broker.OrderChildBrokerMqHandlerService;
import com.clx.performance.vo.mq.broker.BrokerOrderChildSyncMqParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description: 运单同步 mq
 * @Date: 2023-10-20 11:45:08
 * @Version: 1.0
 */
@Slf4j
@Component
public class BrokerOrderChildSyncListener {

    @Autowired
    private OrderChildBrokerMqHandlerService orderChildBrokerMqHandlerService;

    @RabbitListener(queues = RabbitKeyBrokerConstants.ORDER_CHILD_SYNC_QUEUE)
    public void process(Message message) {
        try{
            log.info("无车承运-运单同步, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<BrokerOrderChildSyncMqParam>>(){}).getData());
            log.info("无车承运-运单同步成功, message:{}", new String(message.getBody()));
        }catch (Exception e){
            log.info("无车承运-运单同步 失败，msg:{}", ExceptionUtils.getStackTrace(e));
        }
    }

    private void process(BrokerOrderChildSyncMqParam mq){

        orderChildBrokerMqHandlerService.orderChildSync(mq);

    }
}
