package com.clx.performance.dto.zjxl;

import com.clx.performance.utils.zjxl.ZJXLPositionUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @ClassName TruckTraceDTO
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:03
 * @Version 1.0
 */
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
public class TruckTraceDTO {
    @ApiModelProperty(value = "车牌号",  dataType = "String")
    private String truckNo;
    @ApiModelProperty(value = "正北方向夹角", example = "90",  dataType = "String")
    private BigDecimal angle;
    @ApiModelProperty(value = "GPS 速度", example = "602",  dataType = "String")
    private BigDecimal speed;
    @ApiModelProperty(value = "里程", example = "1500",  dataType = "String")
    private BigDecimal mileage;
    @ApiModelProperty(value = "海拔", example = "3250",  dataType = "String")
    private BigDecimal height;
    @ApiModelProperty(value = "经纬度", example = "[66536286,23780995]",  dataType = "Array")
    private BigDecimal[] location;
    @ApiModelProperty(value = "GPS 时间", example = "20140325/104954",  dataType = "String")
    private String gpsTime;
    private String createTime;
    private String modifiedTime;


    public TruckTraceDTO(String angle, String speed, String mileage, String height, String lon, String lat, String gpsTime) {
        this.angle = new BigDecimal(angle);
        this.speed = ZJXLPositionUtils.speedFormat(speed);
        this.mileage = ZJXLPositionUtils.mileageFormat(mileage);
        this.height = new BigDecimal(height);
        this.location = ZJXLPositionUtils.WGS484Format(lon, lat);
        this.gpsTime = ZJXLPositionUtils.gpsTimeFormat(gpsTime);
    }
}
