package com.clx.performance.dao.linewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.linewarn.LineWarnInfoMapper;
import com.clx.performance.model.linewarn.LineWarnInfo;
import com.clx.performance.param.pc.linewarn.PageLineWarnInfoParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

public interface LineWarnInfoDao extends BaseDao<LineWarnInfoMapper, LineWarnInfo, Integer> {

    boolean updateStatus(LineWarnInfo item);
    boolean batchUpdateStatus(List<Integer> idList, Integer status);
    boolean updateSuspendTime(LineWarnInfo item);
    boolean updateWarnTime(LineWarnInfo item);
    boolean updateByConfig(Integer warnConfigId, String warnName, Integer warnLevel);

    Optional<LineWarnInfo> findById(Integer id);

    Optional<LineWarnInfo> findByOrderGoodsNoAndWarnConfigId(String orderGoodsNo, Integer warnConfigId);

    List<LineWarnInfo> listSuspendTimeout();

    IPage<LineWarnInfo> pageByParam(PageLineWarnInfoParam param);


}
