package com.clx.performance.dao.impl.settle;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.NetworkCaseOutRecordDao;
import com.clx.performance.mapper.settle.NetworkCaseOutRecordMapper;
import com.clx.performance.model.settle.NetworkCaseOutRecord;
import com.clx.performance.param.pc.PageNetworkCaseOutRecordListParam;
import com.clx.performance.vo.pc.NetworkCaseOutRecordVO;
import com.clx.performance.vo.pc.OwnerAccountVO;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
@Repository
public class NetworkCaseOutRecordDaoImpl extends BaseDaoImpl<NetworkCaseOutRecordMapper, NetworkCaseOutRecord, Integer> implements NetworkCaseOutRecordDao {

    @Override
    public IPage<NetworkCaseOutRecordVO> networkCaseOutRecord(PageNetworkCaseOutRecordListParam param) {
        Page<OwnerAccountVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.networkCaseOutRecord(page, param);
    }

    @Override
    public void updateStatus(String childNo, Integer code, String msg) {
        update(lUdWrapper().eq(NetworkCaseOutRecord::getChildNo, childNo)
                .set(NetworkCaseOutRecord::getStatus, code)
                .set(NetworkCaseOutRecord::getFinishTime, LocalDateTime.now())
                .set(NetworkCaseOutRecord::getStatusMsg, msg)
        );
    }
}
