package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.PerformanceProgressDao;
import com.clx.performance.mapper.PerformanceProgressMapper;
import com.clx.performance.model.PerformanceProgress;
import com.clx.performance.param.pc.carrier.PagePerformanceProgress;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Repository
public class PerformanceProgressDaoImpl extends BaseDaoImpl<PerformanceProgressMapper, PerformanceProgress, Integer> implements PerformanceProgressDao {
    @Override
    public IPage<PerformanceProgress> pagePerformanceProgress(List<Integer> statusList, PagePerformanceProgress param){
        Page<PerformanceProgress> page = Page.of(param.getPage(), param.getPageSize());
        LambdaQueryWrapper<PerformanceProgress> query = new LambdaQueryWrapper<>();
        query.in(PerformanceProgress :: getOrderStatus,statusList);
        //最新接单的seq最大，所以这里降序排序
        query.orderByDesc(PerformanceProgress :: getSeq);
        return baseMapper.selectPage(page,query);
    }

    @Override
    public void updateRecordOrder(Long seq,boolean isUp) {
        LambdaUpdateWrapper<PerformanceProgress> update = new LambdaUpdateWrapper<>();
        if(isUp){
            update.gt(PerformanceProgress :: getSeq,seq);
        }else{
            update.ge(PerformanceProgress :: getSeq,seq);
        }
        update.setSql("seq = seq + 1");
        baseMapper.update(null,update);
    }

    @Override
    public long getMaxSeq() {
        LambdaQueryWrapper<PerformanceProgress> query = new LambdaQueryWrapper<>();
        return baseMapper.selectCount(query);
    }

    @Override
    public void updatePerformanceProgress(PerformanceProgress update) {
        LambdaUpdateWrapper<PerformanceProgress> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PerformanceProgress :: getId,update.getId());
        updateWrapper.set(PerformanceProgress :: getTodayExpectComplete,update.getTodayExpectComplete());
        updateWrapper.set(PerformanceProgress :: getTransportExpectArriveStationTime,update.getTransportExpectArriveStationTime());
        updateWrapper.set(PerformanceProgress :: getTradeRequireArriveStationTime,update.getTradeRequireArriveStationTime());
        updateWrapper.set(PerformanceProgress :: getAbnormalRemark,update.getAbnormalRemark());
        updateWrapper.set(PerformanceProgress :: getPerformanceAbnormalReason,update.getPerformanceAbnormalReason());
        updateWrapper.set(PerformanceProgress :: getDispatchFollow,update.getDispatchFollow());
        baseMapper.update(null,updateWrapper);
    }
}
