package com.clx.performance.controller.pc.trace;

import com.clx.performance.param.pc.trace.QueryTraceParam;
import com.clx.performance.service.trace.TraceMonitorService;
import com.clx.performance.service.trace.TruckTraceService;
import com.clx.performance.vo.pc.trace.OrderChildTraceVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

/**
 * @ClassName TraceController
 * @Description
 * @Author kavin
 * @Date 2024/5/13 17:54
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/carrier/trace/monitor")
@Validated
@Api(tags = "PC-承运轨迹监控")
@AllArgsConstructor
public class TraceController{


    private final TraceMonitorService traceMonitorService;

    @ApiOperation(value = "运单轨迹监控", notes = "<br>By:刘海泉")
    @PostMapping("/getOrderChildTrace")
    public Result<OrderChildTraceVO> getOrderChildTrace(@RequestBody @Validated QueryTraceParam param) {
        return Result.ok(traceMonitorService.getOrderChildTrace(param));
    }



    @ApiOperation(value = "车辆轨迹监控", notes = "<br>By:刘海泉")
    @PostMapping("/getTruckTrace")
    public Result<OrderChildTraceVO> getTruckTrace(@RequestBody @Validated QueryTraceParam param) {
        return Result.ok(traceMonitorService.getTruckTrace(param));
    }

}