package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.*;
import com.clx.performance.service.loan.BorrowerService;
import com.clx.performance.vo.pc.loan.carrier.BorrowerVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/borrower")
@Validated
@Api(tags = "承运端-借出方配置")
@AllArgsConstructor
public class CarrierBorrowerController {

    private final BorrowerService borrowerService;


    @ApiOperation(value = "新增借出方", notes = "<br>By:艾庆国")
    @PostMapping("/saveBorrower")
    @UnitCovert
    public Result<Void> saveBorrower(@RequestBody @Validated BorrowerAddParam param) {
        borrowerService.saveBorrower(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新借出方", notes = "<br>By:艾庆国")
    @PostMapping("/updateBorrower")
    public Result<Void> updateBorrower(@RequestBody @Validated BorrowerUpdateParam param) {
        borrowerService.updateBorrower(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新借出方状态", notes = "<br>By:艾庆国")
    @PostMapping("/updateStatus")
    public Result<Void> updateStatus(@RequestBody @Validated BorrowerStatusUpdateParam param) {
        borrowerService.updateStatus(param);

        return Result.ok();
    }

    @ApiOperation(value = "更新删除借出方", notes = "<br>By:艾庆国")
    @PostMapping("/updateDelete")
    public Result<Void> updateDelete(@RequestBody @Validated BorrowerDeleteUpdateParam param) {
        borrowerService.updateDelete(param);

        return Result.ok();
    }

    @ApiOperation(value = "分页搜索借出方列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageBorrower")
    public Result<PageData<BorrowerVO>> pageBorrower(@RequestBody @Validated PageBorrowerParam param) {
        IPage<BorrowerVO> page = borrowerService.pageBorrower(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "查询所有借出方列表",notes = "<br>By:艾庆国")
    @PostMapping("/ListBorrower")
    public Result<List<BorrowerVO>> ListBorrower() {
        return Result.ok(borrowerService.ListBorrower());
    }

}
