package com.clx.performance.controller.pc.collect;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.*;
import com.clx.performance.param.pc.carrier.CarrierPageCollectTruckWaitParam;
import com.clx.performance.service.collect.CollectWaitReportService;
import com.clx.performance.vo.pc.collect.CollectTruckWaitVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/driver/collect/wait")
@Validated
@Api(tags = "承运PC-排队上报")
@AllArgsConstructor
public class CarrierDriverCollectTruckWaitController {

    private final CollectWaitReportService collectWaitReportService;

    @ApiOperation(value = "排队上报审核", notes = "<br>By:艾庆国")
    @PostMapping("/updateWaitReportAudit")
    public Result<Void> updateWaitReportAudit(@RequestBody @Validated CollectLineReportTruckWaitAuditParam param) {
        collectWaitReportService.updateWaitReportAudit(param);

        return Result.ok();
    }

    @ApiOperation(value = "分页查询排队上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageWaitReport")
    public Result<PageData<CollectTruckWaitVO>> pageWaitReport(@RequestBody @Validated CarrierPageCollectTruckWaitParam param) {
        IPage<CollectTruckWaitVO> page = collectWaitReportService.carrierPageWaitReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
