package com.clx.performance.controller.feign;

import com.clx.performance.service.OrderWeightService;
import com.clx.performance.vo.feign.OrderExtractWeightVO;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @ClassName OrderWeightController
 * @Description
 * @Author kavin
 * @Date 2024/8/5 11:45
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/feign/order/weight")
@Validated
@Api(tags = "订单量查询")
@AllArgsConstructor
public class OrderWeightFeignController {

    private final OrderWeightService orderWeightService;


    @ApiOperation(value = "查询订单可提取量",notes = "<br>By:刘海泉")
    @GetMapping("/getOrderCanExtractWeight")
    public Result<OrderExtractWeightVO> getOrderCanExtractWeight(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        return Result.ok(orderWeightService.getOrderCanExtractWeight(orderNo));
    }

    @ApiOperation(value = "查询订单剩余量",notes = "<br>By:刘海泉")
    @GetMapping("/getOrderResidueWeight")
    public Result<BigDecimal> getOrderResidueWeight(@RequestParam("orderNo")
    @NotBlank(message = "订单编号不能为空") String orderNo) {
        return Result.ok(orderWeightService.getOrderResidueWeight(orderNo));
    }


}
