package com.clx.performance.vo.pc.broker;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class TransportParam {

    @ApiModelProperty(value = "用户编号", required = true)
    @NotNull(message = "用户编号不能为空")
    private String userCode;

    @ApiModelProperty(value = "网络货运平台编码", example = "123", required = true, dataType = "String")
    @NotBlank(message = "网络货运平台编码不能为空")
    private String transportPlatformCode;

    @ApiModelProperty(value = "货主手机号（货主账号）", example = "", required = true, dataType = "String")
    @NotBlank(message = "货主手机号（货主账号）不能为空")
    private String ownerMobile;

    @ApiModelProperty(value = "运单编号", required = true)
    @NotBlank(message = "运单编号不能为空")
    private String orderCode;

    @ApiModelProperty(value = "货单", required = true)
    @NotNull(message = "货单不能为空")
    private OpenOrderDTO order;

    @ApiModelProperty(value = "图片", required = true)
    @NotEmpty(message = "运单图片不能为空")
    private List<OpenOrderChildImageDTO> orderChildImage;

    @ApiModelProperty(value = "司机", required = true)
    @NotNull(message = "司机不能为空")
    private OpenOrderChildDriverDTO orderChildDriver;

    @ApiModelProperty(value = "车主", required = true)
    @NotNull(message = "车主不能为空")
    private OpenOrderChildTruckOwnerDTO orderChildTruckOwner;

    @ApiModelProperty(value = "车辆", required = true)
    @NotNull(message = "车辆不能为空")
    private OpenOrderChildTruckDTO orderChildTruck;

    @ApiModelProperty(value = "运单", required = true)
    @NotNull(message = "运单不能为空")
    private OpenOrderChildDTO orderChild;

}
